<!DOCTYPE html>
<!--
 * PHP5 : verifNouvelleVisite.php
 * Vérification des saisies pour une nouvelle visite
 * et création en base de données   
-->

<?php
include_once("modele/accesBDD.php");
$dbh = connexion();
// Vérification de l'existence de la session
session_start();
if (!isset($_SESSION['id'])) {
    $message = "Authentifiez-vous avant de poursuivre";
    header("location:connexion.php?msg=$message");
    exit();
}
$idUtil = $_SESSION['id'];

// Contrôle des saisies
$data = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING); // Récupération des données transmises


if (isset($data["confiance"])) {
    $confiance = $data["confiance"];
} else {
    $confiance = 5 ;
}


// Récupération des valeurs
$idPraticien = $data["ldrPraticien"];
$motifVisite = $data["listemotifVisite"];
$familleMedicament1 = $data["listeFamilleMedicament1"];
$medicament1 = $data["listeMedicament1"];
$familleMedicament2 = $data["listeFamilleMedicament2"];
$remarque = $data["txtRemarque"];
$dateHeureVisite =$data["ztDate"];

if (!empty($data['listeMedicament2'])) {
    // La clé "listeMedicament2" existe dans le tableau et n'est pas vide
    $medicament2 = $data['listeMedicament2'];
} else {
    // La clé "listeMedicament2" n'existe pas dans le tableau ou est vide
    // Faites quelque chose en conséquence, par exemple, attribuer une valeur par défaut à $medicament2
    $medicament2 = '';
}



if (isset($data["txtRemarque"])) {
    // La clé "listeMedicament2" existe dans le tableau
    $remarque = $data["txtRemarque"];
    // Utilisez $medicament2 comme nécessaire
} else {
    // La clé "listeMedicament2" n'existe pas dans le tableau
    // Faites quelque chose en conséquence, par exemple, attribuer une valeur par défaut à $medicament2
    $remarque = '';
}






if($_POST['familleEchantillon']==0)
{
    $familles = 0;
}else
{
    $familles = $_POST['familleEchantillon'];
    $medicaments = $_POST['medicament'];
    $nombres = $_POST['nombre'];
}







// Création de la visite en base de données
if (creerVisite($dbh, $idUtil, $idPraticien,$remarque, $motifVisite, $medicament1, $medicament2, $confiance,$dateHeureVisite)) {
    $message = "Visite créée avec succès";
    $vNum = maxvNumUtil($dbh,$idUtil);
    if($familles!=0)
    {
        // Parcourez les tableaux pour accéder aux valeurs individuelles
        for ($i = 0; $i < count($familles); $i++) {
            $famille = $familles[$i];
            $medicament = $medicaments[$i];
            $nombre = $nombres[$i];
            
            //Ajouter pour chaque ligne, une ligne dans la table échantillon
            ajoutEchantillon($dbh,$idUtil,$vNum,$medicament,$nombre);
        }
    }
    header("location:affichageVisite.php?msg=$message");
} else {
    $message = "Erreur lors de la création de la visite";
    header("location:nouvelleVisite.php?msg=$message");
    exit(); // Ajouter cette ligne pour arrêter l'exécution du script après la redirection
}


?>